% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pch_functions.R
\name{dpch_fun}
\alias{dpch_fun}
\alias{ppch_fun}
\alias{qpch_fun}
\alias{rpch_fun}
\alias{hpch_fun}
\alias{chpch_fun}
\alias{spch_fun}
\alias{pch_functions}
\title{Survival Distributions with piece-wise Constant Hazards (function factories)}
\usage{
dpch_fun(t, lambda)

ppch_fun(t, lambda)

qpch_fun(t, lambda)

rpch_fun(t, lambda, discrete = FALSE)

hpch_fun(t, lambda)

chpch_fun(t, lambda)

spch_fun(t, lambda)

pch_functions(t, lambda, discrete = FALSE)
}
\arguments{
\item{t}{vector of left interval borders}

\item{lambda}{vector of hazards}

\item{discrete}{round survival times to whole numbers in RNG}
}
\value{
\code{dpch_fun} gives the density.

\code{ppch_fun} gives the distribution function

\code{qpch_fun} gives the quantile function.

\code{rpch_fun} gives a function to sample from the given distribution.

\code{hpch_fun} gives the hazard function.

\code{chpch_fun} gives the cumulative hazard function.

\code{spch_fun} gives the survival function.

\code{pch_functions} gives an object of class "miniPCH"
}
\description{
Densitiy, distribution function, quantiles, random numbers, hazard function,
cumulative hazard function and survival function of survival distributions
with piece-wise constant hazards (picewise exponential distributions).

Those functions return functions of one parameter that can be evaluated to
give the density, distribution function, ... The parameters \code{t} and \code{lambda}
are checked only once and not at every function evaluation.
}
\section{Functions}{
\itemize{
\item \code{dpch_fun()}: density of survival distributions with piece-wise constant hazards

\item \code{ppch_fun()}: distribution function of survival distributions with piece-wise constant hazards

\item \code{qpch_fun()}: quantile function of survival distributions with piece-wise constant hazards

\item \code{rpch_fun()}: RNG function of survival distributions with piece-wise constant hazards

\item \code{hpch_fun()}: hazard function of survival distributions with piece-wise constant hazards

\item \code{chpch_fun()}: cumulative hazard function of survival distributions with piece-wise constant hazards

\item \code{spch_fun()}: survival function of survival distributions with piece-wise constant hazards

}}
\examples{
pch_density <- dpch_fun(c(0, 3), c(2, 0.1))
pch_density(1:10)
pch_distr <- ppch_fun(c(0, 3), c(2, 0.1))
pch_distr(1:10)
pch_quant <- qpch_fun(c(0, 3), c(2, 0.1))
pch_quant(seq(0,1, by=0.1))
rpch_fun_cont  <- rpch_fun(c(0, 3), c(2, 0.1))
rpch_fun_discr <- rpch_fun(c(0, 3), c(2, 0.1), discrete=TRUE)
rpch_fun_cont(15)
rpch_fun_discr(15)
pch_haz <- hpch_fun(c(0, 3), c(2, 0.1))
pch_haz(1:10)
pch_cumhaz <- chpch_fun(c(0, 3), c(2, 0.1))
pch_cumhaz(1:10)
pch_surv <- spch_fun(c(0, 3), c(2, 0.1))
pch_surv(1:10)
my_pch <- pch_functions(c(0, 3), c(2, 0.1))
my_pch$t
my_pch$r(15)
my_pch$ch(1:10)
}
\seealso{
\link{pch}
}
