% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleGroup-methods.R
\name{anova-method}
\alias{anova-method}
\alias{anova,SingleGroupClass-method}
\alias{anova,MultipleGroupClass-method}
\alias{anova,MixedClass-method}
\alias{anova,DiscreteClass-method}
\alias{anova,MixtureClass-method}
\title{Compare nested models with likelihood-based statistics}
\usage{
\S4method{anova}{SingleGroupClass}(
  object,
  object2,
  ...,
  bounded = FALSE,
  mix = 0.5,
  frame = 1,
  verbose = FALSE
)
}
\arguments{
\item{object}{an object of class \code{SingleGroupClass},
\code{MultipleGroupClass}, or \code{MixedClass}, reflecting the most constrained model fitted}

\item{object2}{a second model estimated from any of the mirt package estimation methods}

\item{...}{additional less constrained model objects to be compared
sequentially to the previous model}

\item{bounded}{logical; are the two models comparing a bounded parameter (e.g., comparing a single
2PL and 3PL model with 1 df)? If \code{TRUE} then a 50:50 mix of chi-squared distributions
is used to obtain the p-value}

\item{mix}{proportion of chi-squared mixtures. Default is 0.5}

\item{frame}{(internal parameter not for standard use)}

\item{verbose}{(deprecated argument)}
}
\value{
a \code{data.frame}/\code{mirt_df} object
}
\description{
Compare nested models using likelihood ratio test (X2), Akaike Information Criterion (AIC),
Bayesian Information Criterion (BIC),
Sample-Size Adjusted BIC (SABIC), and Hannan-Quinn (HQ) Criterion.
When given a sequence of objects, \code{anova} tests the models against one another
in the order specified. Note that the \code{object} inputs should be ordered in terms
of most constrained model to least constrained.
}
\examples{

\donttest{
x <- mirt(Science, 1)
x2 <- mirt(Science, 2)
anova(x, x2)

# compare three models sequentially (X2 not always meaningful)
x3 <- mirt(Science, 1, 'gpcm')
x4 <- mirt(Science, 1, 'nominal')
anova(x, x2, x3, x4)

# in isolation
anova(x)

# with priors on first model
model <- "Theta = 1-4
          PRIOR = (1-4, a1, lnorm, 0, 10)"
xp <- mirt(Science, model)
anova(xp, x2)
anova(xp)

# bounded parameter
dat <- expand.table(LSAT7)
mod <- mirt(dat, 1)
mod2 <- mirt(dat, 1, itemtype = c(rep('2PL', 4), '3PL'))
anova(mod, mod2) #unbounded test
anova(mod, mod2, bounded = TRUE) #bounded

# priors
model <- 'F = 1-5
          PRIOR = (5, g, norm, -1, 1)'
mod1b <- mirt(dat, model, itemtype = c(rep('2PL', 4), '3PL'))
anova(mod1b)

model2 <- 'F = 1-5
          PRIOR = (1-5, g, norm, -1, 1)'
mod2b <- mirt(dat, model2, itemtype = '3PL')
anova(mod1b, mod2b)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
