% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.group.R
\name{extract.group}
\alias{extract.group}
\title{Extract a group from a multiple group mirt object}
\usage{
extract.group(x, group)
}
\arguments{
\item{x}{model object of class \code{'MultipleGroupClass'} or \code{'MixtureClass'}}

\item{group}{the name of the group to extract}
}
\description{
Extract a single group from an object defined by \code{\link{multipleGroup}},
or as a mixture model from \code{\link{mirt}}.
}
\examples{

\donttest{
set.seed(12345)
a <- matrix(abs(rnorm(15,1,.3)), ncol=1)
d <- matrix(rnorm(15,0,.7),ncol=1)
itemtype <- rep('2PL', nrow(a))
N <- 1000
dataset1 <- simdata(a, d, N, itemtype)
dataset2 <- simdata(a, d, N, itemtype, mu = .1, sigma = matrix(1.5))
dat <- rbind(dataset1, dataset2)
group <- c(rep('D1', N), rep('D2', N))
models <- 'F1 = 1-15'

mod_configural <- multipleGroup(dat, models, group = group)
group.1 <- extract.group(mod_configural, 'D1') #extract first group
summary(group.1)
plot(group.1)
}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\seealso{
\code{\link{extract.item}}, \code{\link{extract.mirt}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{extract}
