% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mitey-package.R
\docType{package}
\name{mitey-package}
\alias{mitey}
\alias{mitey-package}
\title{mitey: Serial Interval and Case Reproduction Number Estimation}
\description{
Provides methods to estimate serial intervals and time-varying case reproduction numbers from infectious disease outbreak data. Serial intervals measure the time between symptom onset in linked transmission pairs, while case reproduction numbers quantify how many secondary cases each infected individual generates over time. These parameters are essential for understanding transmission dynamics, evaluating control measures, and informing public health responses. The package implements the maximum likelihood framework from Vink et al. (2014) \doi{10.1093/aje/kwu209} for serial interval estimation and the retrospective method from Wallinga & Lipsitch (2007) \doi{10.1098/rspb.2006.3754} for reproduction number estimation. Originally developed for scabies transmission analysis but applicable to other infectious diseases including influenza, COVID-19, and emerging pathogens. Designed for epidemiologists, public health researchers, and infectious disease modelers working with outbreak surveillance data.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kylieainslie/mitey}
  \item \url{https://kylieainslie.github.io/mitey/}
  \item Report bugs at \url{https://github.com/kylieainslie/mitey/issues}
}

}
\author{
\strong{Maintainer}: Kylie Ainslie \email{ainslie.kylie@gmail.com} (\href{https://orcid.org/0000-0001-5419-7206}{ORCID}) [copyright holder]

}
\keyword{internal}
