% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_diagnostic_functions.R
\name{fitted.mixpoissonreg}
\alias{fitted.mixpoissonreg}
\title{Fitted Method for \code{mixpoissonreg} Objects}
\usage{
\method{fitted}{mixpoissonreg}(object, type = c("response", "link", "precision", "variance"), ...)
}
\arguments{
\item{object}{object of class "mixpoissonreg" containing results from the fitted model.}

\item{type}{the type of variable to get the fitted values. The default is the "response" type, which provided the estimated values for the means.
The type "link" provides the estimates for the linear predictor of the mean. The type "precision" provides estimates for the precision parameters
whereas the type "variance" provides estimates for the variances.}

\item{...}{Currently not used.}
}
\value{
A vector containing the fitted values of a \emph{mixpoissonreg} object.
}
\description{
Function providing the fitted means, linear predictors, precisions or variances for mixed Poisson regression models.
}
\examples{

daysabs_prog <- mixpoissonreg(daysabs ~ prog, data = Attendance)
fitted(daysabs_prog)

}
\seealso{
\code{\link{predict.mixpoissonreg}}, \code{\link{summary.mixpoissonreg}},
\code{\link{coef.mixpoissonreg}}, \code{\link{vcov.mixpoissonreg}},
\code{\link{plot.mixpoissonreg}}
}
