% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_tidy_mixpoissonreg.R
\name{tidy.mixpoissonreg}
\alias{tidy.mixpoissonreg}
\alias{tidy}
\title{Tidy a \code{mixpoissonreg} object}
\usage{
\method{tidy}{mixpoissonreg}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A \code{mixpoissonreg} object.}

\item{conf.int}{Logical indicating whether or not to include a confidence interval in the tidied output. Defaults to FALSE.}

\item{conf.level}{The confidence level to use for the confidence interval if conf.int = TRUE.
Must be strictly greater than 0 and less than 1. Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments. Currently not used.}
}
\value{
A \emph{tibble} containing the coefficients of the fitted \emph{mixpoissonreg}
object along with its estimates, std. errors, z-statistics and p-values.
}
\description{
Tidy returns a \code{\link[tibble:tibble]{tibble::tibble()}} containing
informations on the coefficients of the model, such as the estimated parameters,
standard errors, z-statistics and p-values. Additionally, it may return confidence
intervals for the model parameters.
}
\seealso{
\code{\link{glance.mixpoissonreg}}, \code{\link{augment.mixpoissonreg}}, \code{\link{tidy_local_influence.mixpoissonreg}},
\code{\link{autoplot.mixpoissonreg}}, \code{\link{local_influence_autoplot.mixpoissonreg}}
}
