% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_tree_trim.R
\name{trim}
\alias{trim}
\title{Trim a context tree}
\usage{
trim(ct, ...)
}
\arguments{
\item{ct}{a context tree.}

\item{...}{additional arguments for the trim function.}
}
\value{
a trimmed context tree.
}
\description{
This function returns a trimmed context tree from which match positions
have been removed.
}
\examples{
## context tree trimming
dts <- sample(as.factor(c("A", "B", "C")), 1000, replace = TRUE)
dts_tree <- ctx_tree(dts, max_depth = 10, min_size = 5, keep_position = TRUE)
print(object.size(dts_tree))
dts_tree <- trim(dts_tree)
print(object.size(dts_tree))
}
