% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureCiWaldCV.R
\name{mlr_measures_ci.wald_cv}
\alias{mlr_measures_ci.wald_cv}
\alias{MeasureCiWaldCV}
\title{Cross-Validation CI}
\description{
Confidence intervals for cross-validation.
The method is asymptotically exact for the so called \emph{Test Error} as defined by Bayle et al. (2020).
For the (expected) risk, the confidence intervals tend to be too liberal.
This inference method can only be applied to decomposable losses.
}
\section{Parameters}{

Those from \code{\link{MeasureAbstractCi}}, as well as:
\itemize{
\item \code{variance} :: \code{"all-pairs"} or \code{"within-fold"}\cr
How to estimate the variance. The results tend to be very similar.
}
}

\examples{
m_waldcv = msr("ci.wald_cv", "classif.ce")
m_waldcv
rr = resample(tsk("sonar"), lrn("classif.featureless"), rsmp("cv"))
rr$aggregate(m_waldcv)
}
\references{
Bayle, Pierre, Bayle, Alexandre, Janson, Lucas, Mackey, Lester (2020).
\dQuote{Cross-validation confidence intervals for test error.}
\emph{Advances in Neural Information Processing Systems}, \bold{33}, 16339--16350.
}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3inferr:MeasureAbstractCi]{mlr3inferr::MeasureAbstractCi}} -> \code{MeasureCiWaldCV}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureCiWaldCV-new}{\code{MeasureCiWaldCV$new()}}
\item \href{#method-MeasureCiWaldCV-clone}{\code{MeasureCiWaldCV$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3inferr" data-topic="MeasureAbstractCi" data-id="aggregate"><a href='../../mlr3inferr/html/MeasureAbstractCi.html#method-MeasureAbstractCi-aggregate'><code>mlr3inferr::MeasureAbstractCi$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureCiWaldCV-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureCiWaldCV-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCiWaldCV$new(measure)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{(\code{\link[mlr3:Measure]{Measure}} or \code{character(1)})\cr
A measure of ID of a measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureCiWaldCV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureCiWaldCV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCiWaldCV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
