% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxhelp.R
\name{CPOLearner}
\alias{CPOLearner}
\title{CPO Learner Object}
\description{
CPO Learners are created when a \code{\link{CPO}} gets attached to an mlr-\code{\link[mlr:makeLearner]{Learner}} object. The resulting
learner performs the operation described by the attached \code{\link{CPO}} before fitting the model specified by the
\code{\link[mlr:makeLearner]{Learner}}. It is possible to attach compound CPOs, and it is possible to attach more CPOs to a learner
that is already a \code{CPOLearner}. If the attached CPO exports hyperparameters, these become part of the newly created
learner and can be queried and set using functions such as \code{\link[mlr]{getParamSet}}, \code{\link[mlr]{getHyperPars}},
and \code{\link[mlr]{setHyperPars}}.

The model created when training a \code{CPOLearner} also contains the relevant \code{\link{CPORetrafo}} information to be applied
to prediction data; this can be retrieved using \code{\link{retrafo}}. The \code{\link{CPOInverter}} functionality is handled
equally transparently by the model.

A CPOLearner can possibly have different \code{\link[mlr]{LearnerProperties}} than the base \code{\link[mlr:makeLearner]{Learner}} to which
it is attached. This depends on the \code{\link{CPO}}'s properties, see \code{\link{CPOProperties}}.

It is possible to retrieve the \code{CPOLearner}'s base learner using \code{\link{getLearnerBare}}, and to get the attached CPOs
using \code{\link{getLearnerCPO}}.
}
\examples{
lrn = makeLearner("classif.logreg")
cpolrn = cpoScale() \%>>\% lrn
print(cpolrn)

getLearnerBare(cpolrn)  # classif.logreg Learner
getLearnerCPO(cpolrn)  # cpoScale() CPO

getParamSet(cpolrn)  # includes cpoScale hyperparameters

model = train(cpolrn, pid.task)  # behaves like a learner
retrafo(model)  # the CPORetrafo that was trained

predict(model, pid.task)  # otherwise behaves like an mlr model

}
\seealso{
Other CPO lifecycle related: 
\code{\link{CPO}},
\code{\link{CPOConstructor}},
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{attachCPO}()},
\code{\link{composeCPO}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOConstructor}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{identicalCPO}()},
\code{\link{makeCPO}()}

Other CPOLearner related: 
\code{\link{attachCPO}()},
\code{\link{getLearnerBare}()},
\code{\link{getLearnerCPO}()}
}
\concept{CPO lifecycle related}
\concept{CPOLearner related}
