% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Heter_LRV}
\alias{Heter_LRV}
\title{Long-run covariance matrix estimators}
\usage{
Heter_LRV(
  e,
  X,
  m,
  tau_n = 0,
  lrv_method = 1L,
  ind = 2L,
  print_deg = 0L,
  rescale = 0L,
  ncp = 0L
)
}
\arguments{
\item{e, }{vector, if the plug-in estimator is used, e should be the vector of residuals, OLS or nonparametric ones. If the difference-based debiased method is adopted, e should be the response time series, i.e., \mjseqn{y}. Specially, e should also be the response time series, i.e., \mjseqn{y}, if the plug-in estimator using the \mjseqn{\breve{\beta}}, the pilot estimator proposed in Bai and Wu (2024).}

\item{X, }{a matrix \mjseqn{n\times p}}

\item{m, }{integer, the window size.}

\item{tau_n, }{double, the smoothing parameter in the estimator. If tau_n is 0, a rule-of-thumb value will be automatically used.}

\item{lrv_method, }{the method of long-run variance estimation, lrvmethod = 0 uses the plug-in estimator in Zhou (2010), lrvmethod = 1 offers the debias difference-based estimator in Bai and Wu (2024), lrvmethod = 2 provides the plug-in estimator using the \mjseqn{\breve{\beta}}, the pilot estimator proposed in Bai and Wu (2024)}

\item{ind, }{types of kernels}

\item{print_deg, }{bool, whether to print information of non-positiveness, default 0\mjseqn{n\times p}}

\item{rescale, }{bool, whether to use rescaling to correct the negative eigenvalues, default 0}

\item{ncp, }{1 no change points, 0 possible change points
\itemize{
\item 1 Triangular \mjseqn{1-|u|}, \mjseqn{u \le 1}
\item 2 Epanechnikov kernel \mjseqn{3/4(1-u^{2})}, \mjseqn{u \le 1}
\item 3 Quartic \mjseqn{15/16(1-u^{2})^{2}}, \mjseqn{u \le 1}
\item 4 Triweight \mjseqn{35/32(1-u^{2})^{3}}, \mjseqn{u \le 1}
\item 5 Tricube  \mjseqn{70/81(1-|u|^{3})^{3}}, \mjseqn{u \le 1}
}}
}
\value{
a cube. The time-varying long-run covariance matrix \mjseqn{p \times p \times n}, where \eqn{p} is the dimension of the time series vector, and \eqn{n} is the sample size.
}
\description{
\loadmathjax The function provides a wide range of estimators for the long-run covariance matrix estimation in non-stationary time series with covariates.
}
\examples{
param = list(d = -0.2, heter = 2, tvd = 0,
tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
data = Qct_reg(1000, param)
sigma = Heter_LRV(data$y, data$x, 3, 0.3, lrv_method = 1)
}
\references{
Bai, L., & Wu, W. (2024). Difference-based covariance matrix estimation in time series nonparametric regression with application to specification tests. Biometrika, asae013.

Zhou, Z. and Wu, W. B. (2010). Simultaneous inference of linear models with time varying coefficients.J. R. Stat. Soc. Ser. B. Stat. Methodol., 72(4):513–531.
}
