% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesSimple.R
\name{bayesRegressSimple}
\alias{bayesRegressSimple}
\title{Perform simple (network) Bayesian regression.}
\usage{
bayesRegressSimple(
  df,
  features,
  targetCol,
  selectedFeatureNames = c(),
  retainMinValues = 2,
  regressor = NULL
)
}
\arguments{
\item{df}{data.frame}

\item{features}{data.frame with bayes-features. One of the features needs to
be the label-column (not required or no value required).}

\item{targetCol}{string with the name of the feature that represents the label
(here the target variable for regression).}

\item{selectedFeatureNames}{vector default \code{c()}. Vector of strings that
are the names of the features the to-predict label depends on. If an empty
vector is given, then all of the features are used (except for the label). The
order then depends on the features' order.}

\item{retainMinValues}{integer to require a minimum amount of data points
when segmenting the data feature by feature.}

\item{regressor}{Function that is given the collected values for
regression and thus finally used to select a most likely value. Defaults
to the built-in estimator for the empirical PDF and returns its argmax.
However, any other function can be used, too, such as min, max, median,
average etc. You may also use this function to obtain the raw values
for further processing.}
}
\description{
Uses simple Bayesian inferencing to segment the data given the
conditional features. Then estimates a density over the remaining values of
the target feature and returns the most likely value using a maximum a posteriori
estimate of the kernel (returning its mode).
}
\examples{
feat1 <- mmb::createFeatureForBayes(
  name = "Sepal.Length", value = mean(iris$Sepal.Length))
feat2 <- mmb::createFeatureForBayes(
  name = "Sepal.Width", value = mean(iris$Sepal.Width))

# Note how we do not require "Petal.Length" among the features when regressing:
mmb::bayesRegressSimple(df = iris, features = rbind(feat1, feat2),
  targetCol = "Petal.Length")
}
\references{
\insertRef{rpkg:bnlearn_4.5}{mmb}
}
\seealso{
\code{mmb::bayesInferSimple()}
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{regression}
\keyword{simple}
