% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesFeature.R
\name{createFeatureForBayes}
\alias{createFeatureForBayes}
\title{Create a Bayesian feature by name and value.}
\usage{
createFeatureForBayes(name, value, isLabel = FALSE, isDiscrete = FALSE)
}
\arguments{
\item{name}{the name of the feature or variable.}

\item{value}{the value of the feature or variable.}

\item{isLabel}{default FALSE. Indicates whether this feature or variable
is the target variable (the label or value to predict).}

\item{isDiscrete}{default FALSE. Used to indicate whether the feature or
variable given is discrete. This will also be set to true if the value
given is a charater, factor or a logical.}
}
\value{
A data.frame with one row holding all the feature's value's
properties.
}
\description{
Transforms a sample's feature's value into a dataframe, that holds
its name, type and value. Currently supports numeric, factor, character
and boolean values. Note that factor is internally converted to
character.
}
\examples{
feat <- mmb::createFeatureForBayes(
  name = "Petal.Width", value = mean(iris$Petal.Width))
featTarget <- mmb::createFeatureForBayes(
  name = "Species", iris[1,]$Species, isLabel = TRUE)
}
\seealso{
\code{sampleToBayesFeatures} that uses this function
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{feature}
