% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCA_par.R
\name{OSCA_par}
\alias{OSCA_par}
\title{OSCA_par}
\usage{
OSCA_par(
  df,
  externalVar,
  ILCincrement = 0.05,
  oscaPath,
  remlAlg = 0,
  maxRemlIt = 100,
  numCovars = NULL,
  catCovars = NULL,
  permute = TRUE,
  numNodes = 1,
  verbose = TRUE
)
}
\arguments{
\item{df}{n x p data frame or matrix of numeric -omics values with no ID column}

\item{externalVar}{vector of length n of external variable values with no ID column}

\item{ILCincrement}{float between zero and one determining interval between tested ILC values; default is 0.05}

\item{oscaPath}{absolute path to OSCA software}

\item{remlAlg}{which algorithm to run REML iterations in GCTA; 0 = average information (AI), 1 = Fisher-scoring, 2 = EM; default is 0 (AI)}

\item{maxRemlIt}{the maximum number of REML iterations; default is 100}

\item{numCovars}{n x c_n matrix of numerical covariates to adjust heritability model for; must be in same person order as externalVar; default is NULL}

\item{catCovars}{n x c_c matrix of categorical covariates to adjust heritability model for; must be in same person order as externalVar; default is NULL}

\item{permute}{boolean value for whether or not to calculate values for a random permutation of the external variable; default is true}

\item{numNodes}{number of available compute nodes for parallelization; default is 1}

\item{verbose}{logical for whether or not to display progress updates; default is TRUE}
}
\value{
Data frame with columns

\describe{
\item{ILC}{the information loss criterion used for that iteration}
\item{InformationLost}{percent information lost due to data reduction}
\item{PercentReduction}{percent of variables condensed compared to unreduced data}
\item{VarianceExplained_Observed}{percent variance explained in observed external variable by the data}
\item{SE_Observed}{standard error of the percent variance estimate for observed external variable}
\item{VarianceExplained_Permuted}{percent variance explained in permuted external variable by the data; only if input parameter "permute" is true}
\item{SE_Permuted}{standard error of the percent variance estimate for permuted external variable; only if input parameter "permute" is true}
}
}
\description{
OSCA_par determines the percent variance explained in an external variable (exposures or responses) for a range of increasingly reduced datasets. Dimension reduction is done with Partition, where features are only condensed into modules if the intraclass correlation between the features is at least the user-supplied information loss criterion (ILC), 0 <= ILC <= 1. An ILC of one returns the full dataset with no reduction, and an ILC of zero returns one module of all input features, reducing the dataset to the mean value. For each ILC value, with the number of ILCs tested determined by input parameter ILCincrement, the function returns the point estimate and standard error of the percent variance explained in the observed external variable by the reduced dataset. If input parameter permute is true, the function also returns the same values for a random permutation of the external variable.
}
\details{
OmicS-data-based Complex trait Analysis (OSCA) is a suite of C++ functions. In order to use the OSCA functions, the user must specify the absolute path to the OSCA software, which can be downloaded from the Yang Lab website \href{https://yanglab.westlake.edu.cn/software/osca/#Download}{here}.

Here, we use OSCA's Omics Restricted Maximum Likelihood (OREML) method to estimate the percent of variance in an external phenotype that can be explained by an omics profile, akin to heritability estimates in GWAS. OREML is called twice for each ILC tested if permutations are included.

Dimension reduction is done with Partition, an agglomerative data reduction method which performs both feature condensation and extraction based on a user provided information loss criterion (ILC). Feature condensation into modules are only accepted if the intraclass correlation between the features is at least the ILC. The superPartition function is called if the gene expression dataset contains more than 4,000 features.
}
\examples{
#load CCA package for example dataset
library(CCA)

# load dataset
data("nutrimouse")

# run function; input absolute path to OSCA software before running
\dontrun{OSCA_par(df = nutrimouse$gene, 
          externalVar = as.numeric(nutrimouse$diet),
          ILCincrement = 0.25, 
          oscaPath = "pathHere")}

}
\references{
Benjamini Y, Hochberg Y. Controlling the false discovery rate: a practical and powerful approach to multiple testing. \emph{Journal of the Royal statistical society: series B (Methodological)} \strong{57} (1995) 289–300.

Martin P, et al. Novel aspects of PPARalpha-mediated regulation of lipid and xenobiotic metabolism revealed through a nutrigenomic study. \emph{Hepatology}, in press, 2007.

Millstein J, Battaglin F, Barrett M, Cao S, Zhang W, Stintzing S, et al. Partition: a surjective mapping approach for dimensionality reduction. \emph{Bioinformatics} \strong{36} (2019) 676–681. doi:10.1093/bioinformatics/ btz661.

Queen K, Nguyen MN, Gilliland F, Chun S, Raby BA, Millstein J. ACDC: a general approach for detecting phenotype or exposure associated co-expression. \emph{Frontiers in Medicine} (2023) 10. doi:10.3389/fmed.2023.1118824.
}
\seealso{
OSCA software - \url{https://yanglab.westlake.edu.cn/software/osca/}
}
\author{
Katelyn Queen, \email{kjqueen@usc.edu}
}
