% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_set_combined.R
\name{model_set_combined}
\alias{model_set_combined}
\title{Two or More Hypothesized Models}
\usage{
model_set_combined(model_set_outputs, ...)
}
\arguments{
\item{model_set_outputs}{This must be
a named list of the outputs of
\code{\link[=model_set]{model_set()}}. The names will be used
as prefixes to name the models.}

\item{...}{Additional arguments to be
passed to \code{\link[=model_set]{model_set()}}.}
}
\value{
A \code{model_set}-class object, which is
simply an output of \code{\link[=model_set]{model_set()}}.
All methods and functions for the
output of \code{\link[=model_set]{model_set()}} will also
work on this object.
}
\description{
Combine the 'model_set()'
results of two or more hypothesis
models.
}
\details{
There are cases in which users
have more than one hypothesized model,
each with its own set of neighboring
models.

The function \code{\link[=model_set_combined]{model_set_combined()}}
let users combine the \code{\link[=model_set]{model_set()}}
results two or more hypothesized model.
Users can then compare the BPPs
of these hypothesized models, as well
as their neighboring models. Equivalent
models will be removed in the process.
}
\examples{

library(lavaan)

mod1 <-
"
x4 ~ x1
x7 ~ x4
"

mod2 <-
"
x1 ~ x4
x7 ~ x4
"

fit1 <- sem(mod1,
            HolzingerSwineford1939,
            fixed.x = FALSE)
fit2 <- sem(mod2,
            HolzingerSwineford1939,
            fixed.x = FALSE)

out1 <- model_set(fit1)
out2 <- model_set(fit2)

out1
out2

outb <- model_set_combined(
            list(fit1 = out1,
                 fit2 = out2))

outb

}
\seealso{
\code{\link[=model_set]{model_set()}}
}
