% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_spec_mode_engine_val}
\alias{check_spec_mode_engine_val}
\title{Error handling for unknown mode}
\usage{
check_spec_mode_engine_val(model, mode, eng, call = caller_env())
}
\arguments{
\item{model}{Character of specific model}

\item{mode}{Character of specific mode}

\item{eng}{Character of specific engine}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An error
}
\description{
Checks that a given model, mode, engine combination have been registered.
}
\examples{
library(rlang)
tmp <- catch_cnd(check_spec_mode_engine_val("turtle", "partition", "vegan"))
}
