% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{un_member_states_2024}
\alias{un_member_states_2024}
\title{UN Member States 2024 Dataset}
\format{
A data frame with 193 rows and 39 columns:
\describe{
\item{country}{\code{character}. Name of the country.}
\item{iso}{\code{character}. ISO 3166-1 alpha-3 country code. See: \url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}}
\item{official_state_name}{\code{character}. Official name of the country. See: \url{https://en.wikipedia.org/wiki/List_of_countries_and_dependencies_and_their_capitals_in_native_languages}}
\item{continent}{\code{factor}. Continent where the country is located. See: \url{https://en.wikipedia.org/wiki/Continent}}
\item{region}{\code{character}. Specific region within the continent.}
\item{capital_city}{\code{character}. Name of the capital city. See: \url{https://en.wikipedia.org/wiki/List_of_national_capitals_by_population}}
\item{capital_population}{\code{numeric}. Population of the capital city.}
\item{capital_perc_of_country}{\code{numeric}. Percentage of the country’s population living in the capital.}
\item{capital_data_year}{\code{integer}. Year the capital population data was collected.}
\item{gdp_per_capita}{\code{numeric}. GDP per capita in USD. See: \url{https://data.worldbank.org/indicator/NY.GDP.PCAP.CD}}
\item{gdp_per_capita_year}{\code{numeric}. Year the GDP per capita data was collected.}
\item{summers_competed_in}{\code{numeric}. Number of times the country has competed in the Summer Olympics}
\item{summer_golds}{\code{integer}. Number of gold medals won in the Summer Olympics.}
\item{summer_silvers}{\code{integer}. Number of silver medals won in the Summer Olympics.}
\item{summer_bronzes}{\code{integer}. Number of bronze medals won in the Summer Olympics.}
\item{summer_total}{\code{integer}. Total number of medals won in the Summer Olympics.}
\item{winters_competed_in}{\code{integer}. Number of times the country has competed in the Winter Olympics}
\item{winter_golds}{\code{integer}. Number of gold medals won in the Winter Olympics.}
\item{winter_silvers}{\code{integer}. Number of silver medals won in the Winter Olympics.}
\item{winter_bronzes}{\code{integer}. Number of bronze medals won in the Winter Olympics.}
\item{winter_total}{\code{integer}. Total number of medals won in the Winter Olympics.}
\item{combined_competed_ins}{\code{integer}. Total number of times the country has competed in both Summer and Winter Olympics. See: \url{https://en.wikipedia.org/wiki/All-time_Olympic_Games_medal_table}}
\item{combined_golds}{\code{integer}. Total number of gold medals won in both Summer and Winter Olympics.}
\item{combined_silvers}{\code{integer}. Total number of silver medals won in both Summer and Winter Olympics.}
\item{combined_bronzes}{\code{integer}. Total number of bronze medals won in both Summer and Winter Olympics.}
\item{combined_total}{\code{integer}. Total number of medals won in both Summer and Winter Olympics.}
\item{driving_side}{\code{character}. Indicates whether the country drives on the left or right side of the road. See: \url{https://en.wikipedia.org/wiki/Left-_and_right-hand_traffic}}
\item{obesity_rate_2024}{\code{numeric}. Percentage of the population classified as obese in 2024. See: \url{https://en.wikipedia.org/wiki/List_of_countries_by_obesity_rate}}
\item{obesity_rate_2016}{\code{numeric}. Percentage of the population classified as obese in 2016.}
\item{has_nuclear_weapons_2024}{\code{logical}. Indicates whether the country has nuclear weapons as of 2024. See: \url{https://en.wikipedia.org/wiki/List_of_states_with_nuclear_weapons}}
\item{population_2024}{\code{numeric}. Population of the country in 2024. See: \url{https://data.worldbank.org/indicator/SP.POP.TOTL}}
\item{area_in_square_km}{\code{numeric}. Area of the country in square kilometers. See: \url{https://en.wikipedia.org/wiki/List_of_countries_and_dependencies_by_area}}
\item{area_in_square_miles}{\code{numeric}. Area of the country in square miles.}
\item{population_density_in_square_km}{\code{numeric}. Population density in square kilometers.}
\item{population_density_in_square_miles}{\code{numeric}. Population density in square miles.}
\item{income_group_2024}{\code{factor}. World Bank income group classification in 2024. See: \url{https://data.worldbank.org/indicator/NY.GNP.PCAP.CD}}
\item{life_expectancy_2022}{\code{numeric}. Life expectancy at birth in 2022. See: \url{https://en.wikipedia.org/wiki/List_of_countries_by_life_expectancy}}
\item{fertility_rate_2022}{\code{numeric}. Fertility rate in 2022 (average number of children per woman). See: \url{https://en.wikipedia.org/wiki/List_of_countries_by_total_fertility_rate}}
\item{hdi_2022}{\code{numeric}. Human Development Index in 2022. See: \url{https://en.wikipedia.org/wiki/List_of_countries_by_Human_Development_Index}}
}
}
\usage{
un_member_states_2024
}
\description{
This dataset contains information on 193 United Nations member states as of 2024. It includes various attributes such as country names, ISO codes, official state names, geographic and demographic data, economic indicators, and participation in the Olympic Games. The data is designed for use in statistical analysis, data visualization, and educational purposes.
}
\examples{
data(un_member_states_2024)
head(un_member_states_2024)
}
\keyword{datasets}
