% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalised_prep.R
\name{generalizedMatrix}
\alias{generalizedMatrix}
\title{Generalized Lambda and Poisson preparation}
\usage{
generalizedMatrix(
  data,
  variables = colnames(data),
  bin_variables = NULL,
  generalized_mode_model = NULL,
  multi_sugg_prop = NULL
)
}
\arguments{
\item{data}{a data frame with original variables.}

\item{variables}{a vector of which variables you want to transform.
Default:colnames(data)}

\item{bin_variables}{a character vector listing the binary variables.}

\item{generalized_mode_model}{A matrix that contains two columns named "Variables" and
"Model". This matrix can be used only if a generalized_mode_model argument is
provided. It specifies what model should be used for each Variable.
Model values should be "RMFMKL", "RPRS", "STAR" or a combination of them,
e.g. "RMFMKL-RPRS" or "STAR-STAR", in case the use wants a bimodal simulation.
The user can select Generalized Poisson model for poisson variables,
but this model cannot be included in bimodal simulation}

\item{multi_sugg_prop}{A named vector that provides a  proportion of
value=1 for specific binary variables(=name of the vector) that will be
the close to the proportion of this value in the simulated data sets}
}
\value{
A numeric matrix with the four moments for each distribution and 
a number that corresponds to a GLD model
}
\description{
Prepare the four moments matrix for GLD and GPD
}
\examples{
\donttest{ 
data("Cleveland",package="modgo")
Variables <- c("Age","STDepression")
Model <- c("rprs", "star-rmfmkl")
model_matrix <- cbind(Variables,
                     Model)
test_modgo <- generalizedMatrix(data = Cleveland,
     generalized_mode_model = model_matrix,
     bin_variables = c("CAD","HighFastBloodSugar","Sex","ExInducedAngina"))
}
}
\author{
Francisco M. Ojeda, George Koliopanos
}
