% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_one.r
\name{flattenj_one}
\alias{flattenj_one}
\title{Single JSON Object Flatten}
\usage{
flattenj_one(dat, sep = "@", compact = TRUE)
}
\arguments{
\item{dat}{\code{list}. The list from a JSON object.}

\item{sep}{\code{character}. A character/string used to separate keys in the nesting path.
Defaults to @ to avoid the occasional overriding. Not recommended to use some risky characters like . and \.
When \code{compact = FALSE}, it is unnecessary to assign \code{sep} explicitly, unless @ has been used in the key fields.}

\item{compact}{logical. Whether to generate the compact or completely expanded data frame. Defaults to \code{TRUE}.}
}
\value{
\code{data frame}. The flattened result.
}
\description{
Transform a JSON object into a flattened data frame in a serialization way.
}
\details{
The function flattens a single JSON object into a data frame with two different schemas according to the \code{compact} value.
\itemize{
\item{For \code{compact = TRUE}, the data frame contains two columns. One is \code{paths} which stores the absolute path of each record.
And the other is \code{values} which stores the corresponding values of each path.}
\item{For \code{compact = FALSE}, the data frame has more columns based on the global nesting situation.}
}
\bold{It actually applies the serialization way for flattening, which means the early values correspondingly appear in the heading rows of the data frame.}
And if the value is a list object in the original data or a non-named list/vector in the R environment,
the path will be correspondingly appended with an integer to specify each list element.
For example, in the raw JSON file, "\{'a':[1, 2, 3]\}" will be \code{data.frame(paths = c('a1', 'a2', 'a3'), values = c(1, 2, 3))}.
Great credits to the answer of \href{https://stackoverflow.com/questions/8139677/how-to-flatten-a-list-to-a-list-without-coercion/8139959#8139959}{Tommy}.
}
\examples{
library(mojson)
j <- list(a = list(x = 1, y = 2),
          b = c(3, 4, list(z = 5, s = 6, t = list(m = 7, n = 8))))
flattenj_one(j)
flattenj_one(j, compact = FALSE)

}
\seealso{
\code{\link{expanddf}}.
}
