% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcv.R
\name{ggcv}
\alias{ggcv}
\title{GGPlot the Mean Square Error with Error Bar for +/- 1 Standard Error}
\usage{
ggcv(
  cv.obj,
  title = "MSE for CV of monothetic clustering",
  xlab = "Number of clusters",
  ylab = "MSE +/- 1 SE",
  type = c("b", "p", "l"),
  linetype = 2,
  err.col = "red",
  err.width = 0.2
)
}
\arguments{
\item{cv.obj}{A \code{cv.MonoClust} object (output of \code{\link[=cv.test]{cv.test()}}).}

\item{title}{Overall title for the plot.}

\item{xlab}{Title for x axis.}

\item{ylab}{Title for y axis.}

\item{type}{What type of plot should be drawn. Choosing between \code{"l"} (line
only), \code{"p"} (point only), and \code{"b"} (both line and point).}

\item{linetype}{The line type. See \code{vignette("ggplot2-specs")}.}

\item{err.col}{Color of the error bars.}

\item{err.width}{Width of the bars.}
}
\value{
A ggplot2 object.
}
\description{
GGPlot the Mean Square Error with Error Bar for +/- 1 Standard Error
}
\examples{
\donttest{
library(cluster)
data(ruspini)

# 10-fold cross-validation
cptable <- cv.test(ruspini, minnodes = 2, maxnodes = 4)
ggcv(cptable)
}
}
\seealso{
Plot using base R \code{\link[=plot.cv.MonoClust]{plot.cv.MonoClust()}}
}
