% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reproFitTT.R
\name{plot.reproFitTT}
\alias{plot.reproFitTT}
\title{Plotting method for \code{reproFitTT} objects}
\usage{
\method{plot}{reproFitTT}(
  x,
  xlab = "Concentration",
  ylab = "Nb of offspring per ind/day",
  main = NULL,
  fitcol = "orange",
  fitlty = 1,
  fitlwd = 1,
  spaghetti = FALSE,
  cicol = "orange",
  cilty = 2,
  cilwd = 1,
  ribcol = "grey70",
  addlegend = FALSE,
  log.scale = FALSE,
  style = "ggplot",
  ...
)
}
\arguments{
\item{x}{an object of class \code{reproFitTT}}

\item{xlab}{a label for the \eqn{X}-axis, by default \code{Concentration}}

\item{ylab}{a label for the \eqn{Y}-axis, by default \code{Nb of offspring per ind/day}}

\item{main}{main title for the plot}

\item{fitcol}{color of the fitted curve}

\item{fitlty}{line type of the fitted curve}

\item{fitlwd}{width of the fitted curve}

\item{spaghetti}{if \code{TRUE}, the credible interval is represented by 
multiple curves}

\item{cicol}{color of the 95 \% credible limits}

\item{cilty}{line type of the 95 \% credible limits}

\item{cilwd}{width of the 95 \% credible limits}

\item{ribcol}{color of the ribbon between lower and upper credible limits.
Transparent if \code{NULL}}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{log.scale}{if \code{TRUE}, displays \eqn{X}-axis in log-scale}

\item{style}{graphical backend, can be \code{'ggplot'} or \code{'generic'}}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the \code{reproFitTT} class.
It plots the concentration-effect fit under target time reproduction
analysis.
}
\details{
The fitted curve represents the \strong{estimated reproduction rate} at the target time
 as a function of the chemical compound concentration.
The function plots 95\% credible intervals for the estimated reproduction
rate (by default the grey area around the fitted curve). Typically
a good fit is expected to display a large overlap between the two types of intervals.
If spaghetti = TRUE, the credible intervals are represented by two dotted
lines limiting the credible band, and a spaghetti plot is added to this band.
It consists of the representation of simulated curves using parameter values
sampled in the posterior distribution (10\% of the MCMC chains are randomly
taken for this sample).
}
\note{
When \code{style = "generic"}, the function calls the generic function
\code{\link[graphics]{plot}}

When \code{style = "ggplot"}, the function return an object of class
 \code{ggplot}, see function \code{\link[ggplot2]{ggplot}}
}
\keyword{plot}
