% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{control}
\alias{control}
\title{Optimal Control}
\usage{
control(
  counts,
  time,
  mu = 1/14,
  m = 3,
  n_lam = 25,
  kmax = 20,
  global_opt = 0,
  n_pulse = 4,
  rho = 0.3,
  days_between = 3,
  max_eval = 10000
)
}
\arguments{
\item{counts}{Numeric vector of population counts.}

\item{time}{Numeric vector with corresponding day of year measurments.
Example: Jan 1st = day 1.  Must be same length as \code{counts}.}

\item{mu}{Numeric indicating natural population death rate.}

\item{m}{Numeric indicating number of lifetimes for population decay
between seasons}

\item{n_lam}{Numeric max fourier mode order to calculate.}

\item{kmax}{Numeric max number of dynamics fourier modes to use in calculating
fourier sum (different than N_lam = max emergence fourier mode set by user
for curve fitting portion of the code. Kmax should be an integer between
2 and 200, default at 20.}

\item{global_opt}{Numeric set to 0 if user chooses local optimum, 1 if user
chooses golbal GN_DIRECT_L_RAND method, 2 if user chooses global
GN_ISRES method.}

\item{n_pulse}{Numeric number of pulses, set by user, integer between
1 and 10.}

\item{rho}{Numeric percent knockdown (user set between .01 and .30,
e.g. 1\% to 30\% knockdown).}

\item{days_between}{Numeric minimum number of days allowed between pulses
set by user (integer bewtween 0 and 30 days).}

\item{max_eval}{Numeric maximum evaluations for optimization step.}
}
\value{
Control list of control parameters.
}
\description{
Creates optimal schedule of pulses for mosquito control.
}
\examples{
y_in <- c(15, 40, 45, 88, 99, 145, 111, 132, 177, 97, 94, 145, 123, 111,
125, 115, 155, 160, 143, 132, 126, 125, 105, 98, 87, 54, 55, 8
)
t_in_user <- c(93, 100, 107, 114, 121, 128, 135, 142, 149, 163, 170, 177,
184, 191, 198, 205, 212, 219, 226, 233, 240, 247, 254, 261,
267, 274, 281, 288
)
control(y_in, t_in_user, global_opt = -1)


}
