% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{count_motifs}
\alias{count_motifs}
\title{Count multi-level motifs}
\usage{
count_motifs(
  net,
  motifs,
  lvl_attr = c("sesType"),
  assume_sparse = TRUE,
  omit_total_result = TRUE,
  directed = NULL
)
}
\arguments{
\item{net}{A network object with a node attribute specifying the
level of each node}

\item{motifs}{a list of motif identifiers which shall be counted, e.g.
\code{list("1,2[I.C]")}}

\item{lvl_attr}{character vector specifying the vertex attribute name where
level information is stored in \code{net}}

\item{assume_sparse}{whether the network shall be assumed to be sparse (for
optimization), default TRUE}

\item{omit_total_result}{whether total results shall be omitted, default
FALSE}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
data frame with a column containing motif identifier strings and one
  column containing motif counts
}
\description{
Count multi-level motifs
}
\examples{
\dontrun{
count_motifs(ml_net,
  lvl_attr = c("sesType"),
  motifs = list("1,2[I.C]", "1,2[II.C]", "2,1[I.C]", "2,1[II.C]"),
  directed = FALSE
)
}
}
