% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFossilToPhy.R
\name{addFossilToPhy}
\alias{addFossilToPhy}
\title{add a fossil to an interior branch of a time-scaled phylogeny}
\usage{
addFossilToPhy(
  phy,
  inGroup,
  fossil,
  fossilAge,
  minLength = 0.1,
  maxLength = NULL
)
}
\arguments{
\item{phy}{Input phylogeny an object of class \code{phylo} (see \pkg{ape})}

\item{inGroup}{vector of tip labels defined as the ingroup - the fossil(s) will be placed on the stem branch leading to the 'inGroups' most recent common ancestor}

\item{fossil}{tip labels for the new fossil}

\item{fossilAge}{age of the fossil}

\item{minLength}{minimum length leading to the fossil}

\item{maxLength}{maximum length leading to the fossil. If \code{NULL} (default) then the maximum bound is half the length of the branch leading to the crown node}
}
\value{
the the time-scaled phylogeny with the fossil attached
}
\description{
the function takes a time-scaled phylogeny and adds a fossil at a branch in the past
}
\examples{
data(anolis.tree)
plot(anolis.tree)
nodelabels(214, 214)
# add fossil to node 214
in.groups <- node.descendents(x=214, phy=anolis.tree, tip.labels=TRUE)[[2]]
fossilPhy <- addFossilToPhy(anolis.tree, in.groups, fossil="fakeFossil", fossilAge=60)
plot(fossilPhy)
}
\references{
Puttick, M. N., Kriwet, J., Wen, W., Hu, S., Thomas, G. H., & Benton, M. J. (2017). Body length of bony fishes was not a selective factor during the biggest mass extinction of all time. Palaeontology, 60, 727-741.
}
\author{
Mark Puttick
}
