% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rateData.R
\name{as.rateData}
\alias{as.rateData}
\title{Conversion among data and phylogeny objects}
\usage{
as.rateData(
  y,
  x,
  rateMatrix = NULL,
  phy = NULL,
  data,
  meserr.col = NULL,
  meserr.propn = NULL,
  log.y = FALSE,
  report_prune = FALSE
)
}
\arguments{
\item{y}{The response variable - typically a continuous trait. Specified as a column name or index}

\item{x}{The explanatory (discrete) variable used to define the hypothesised rate categories. Specified as a column name or index.}

\item{rateMatrix}{A "rateMatrix" object or NULL}

\item{phy}{An object of class "phylo" (see \pkg{ape}).}

\item{data}{A data frame containing (minimally) the x and y variables as columns with species names as rownames.}

\item{meserr.col}{Column name or index containing measurement error for species means.}

\item{meserr.propn}{Single value specifying the proportional measurement to be applied across all species.}

\item{log.y}{Logical, natural log transform response variable.}

\item{report_prune}{Logical. Prints a list of dropped species if TRUE}
}
\value{
rateData An object of class "rateData" which is a list containing the response (y) and explanatory (x) variable along with a list of variance-covaraince matrices.
}
\description{
Function to generate a "rateData" object containing the discrete explanatory variable, continuous response variable and set of variance co-variance matrices. It loads the trait data and removes species with missing data from the data and vcv matrix. 
\code{as.rateData} requires either a set of matrices in rateMatrix format created using \code{as.rateMatrix} or, if no rateMatrix object is input then it requires a phylogeny in "phylo" format. If  a "phylo" object is used  \code{as.rateData} will call \code{as.rateMatrix} internally.
\code{as.rateMatrix} calls the "ape" function \code{vcv.phylo} multiple times and this can be slow for large phylogenies. It will often be more efficient to use \code{as.rateMatrix} first to create a "rateMatrix" object to pass to \code{as.rateData}, particularly if there are many response traits of interest to be fitted to the same phylogeny and set of reconstructed ancestral states.
}
\examples{
## Read in phylogeny and data from Thomas et al. (2009)
data(anolis.tree)
data(anolis.data)

## Convert data to class rateData with a rateMatrix object as input
anolis.rateMatrix <- as.rateMatrix(phy=anolis.tree, x="geo_ecomorph", data=anolis.data)

anolis.rateData <- as.rateData(y="Female_SVL", x="geo_ecomorph", 
rateMatrix = anolis.rateMatrix, phy=NULL, data=anolis.data, log.y=TRUE)  

## Convert data to class rateData with a phylo object as input 
anolis.rateData <- as.rateData(y="Female_SVL", x="geo_ecomorph", 
rateMatrix = NULL, phy=anolis.tree, data=anolis.data, log.y=TRUE)
}
\references{
Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments and island effects. Evolution 63, 2017-2030.
}
\author{
Gavin Thomas
}
