% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pic.pgls.R
\name{pic.pgls}
\alias{pic.pgls}
\title{Fast PLGS estimation based on contrasts}
\usage{
pic.pgls(
  formula,
  phy,
  y,
  lambda = "ML",
  return.intercept.stat = FALSE,
  meserr = NULL
)
}
\arguments{
\item{formula}{A model formula with continuous variables only}

\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{y}{A matrix of trait values with rownames corresponding to the phy tip labels, and column names corresponding to the formula variable names}

\item{lambda}{Default is "ML" meaning the phylogenetic signal of the response variable will be estimated using restricted Maximum likelihood. If a numeric value between 0-1 is provided this will be used in the calculation of regression coefficients}

\item{return.intercept.stat}{Logical. If \code{TRUE} the standard errors, t value, and p value of the estimated Intercept is provided for comparison with output from \code{\link[caper]{pgls}} from \pkg{caper} etc.,. Default is \code{FALSE} as this slows the function as it involves constructing and calculating the inverse of the phy variance-covariance matrix, and based on contrasts the design matrix column of ones would have zero contrasts.}

\item{meserr}{A vector (or matrix) of measurement error for each tip. This is only applicable to univariate analyses.}
}
\value{
A list containing the model, model summary, intercept, estimate of Lambda, model log-Likelihood, model AIC
}
\description{
Estimates regression parameters for a phylogenetic generalised least-squares analysis using the fast constrasts method (Felsenstein 1973; 1985; Freckleton 2012). This implementation is applicable for continuous traits only and not factors
}
\examples{
# Data and phylogeny
data(anolis.tree)
anolis.tree$node.label <- NULL
lm.data <- transformPhylo.sim(phy=anolis.tree, n=2, model="bm")
dat <- data.frame(x = lm.data[,1], y = lm.data[,2],
names = anolis.tree$tip, row.names = anolis.tree$tip)
picModel <- pic.pgls(formula=y ~  x,
phy=anolis.tree, y = dat, lambda=1,
return.intercept.stat=FALSE)
}
\seealso{
\code{\link[caper]{pgls}}
}
\author{
Mark N Puttick and Rob Freckleton
}
