% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{map_to_granger_test}
\alias{map_to_granger_test}
\title{Map duration object comments to a Granger Test object}
\usage{
map_to_granger_test(d, g, influence1, influence2)
}
\arguments{
\item{d}{DurationObject}

\item{g}{GrangerTest object}

\item{influence1}{Comment X>Y string in the Granger Test of Y~X i.e. X causes Y}

\item{influence2}{Comment X>Y string in the Granger Test of Y~X i.e. X causes Y}
}
\value{
modified Duration object
}
\description{
Map duration object comments to a Granger Test object
}
\examples{
r <- get_sample_recording()
fv_list <- get_filtered_views(r, data_points = "Nose", n = 41, p = 3)
jv_sub <- get_joined_view(fv_list)
splicing_df <- splice_time(jv_sub, win_size = 5, step_size = 0.5)
sv <- get_spliced_view(jv_sub, splicing_df)
g <- granger_test(sv, "Nose_x_Central_Sitar", "Nose_x_Central_Tabla", lag = 1/25)
d <- get_duration_annotation_data(r)
map_to_granger_test(d, g, "Influence T>S", "Influence S>T")
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{get_granger_interactions}()},
\code{\link{granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
