% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CImapGrid.R
\name{plot.CImapGrid}
\alias{plot.CImapGrid}
\title{Plot of simultaneous credible intervals.}
\usage{
\method{plot}{CImapGrid}(
  x,
  color = c("firebrick1", "gainsboro", "dodgerblue3"),
  turnOut = TRUE,
  title,
  aspRatio = 1,
  ...
)
}
\arguments{
\item{x}{List containing the simultaneous credible intervals for all
differences of smooths.}

\item{color}{Vector of length 3 containing the colors to be used in the 
credibility maps. The first color represents the credibly negative pixels, 
the second color the pixels that are not credibly different from zero
and the third color the credibly positive pixels.}

\item{turnOut}{Logical. Should the output images be turned 90 degrees 
counter-clockwise?}

\item{title}{Vector containing one string per plot. The required 
number of titles is equal to \code{length(mrbOut$ciout)}. If no \code{title} 
is passed, defaults are used.}

\item{aspRatio}{Adjust the aspect ratio of the plots. The default \code{aspRatio = 1}
produces square plots.}

\item{...}{Further graphical parameters can be passed.}
}
\value{
Plots of simultaneous credible intervals for all differences of
    smooths are created.
}
\description{
Maps with simultaneous credible intervals for all differences of smooths
at neighboring scales \eqn{z_{i}} are plotted.
}
\details{
The default colors of the maps have the following meaning:
\itemize{
\item \strong{Blue}: Credibly positive pixels.
\item \strong{Red}: Credibly negative pixels.
\item \strong{Grey}: Pixels that are not credibly different from zero.
}
\code{x} corresponds to the \code{ciout}-part of the output 
of \code{\link{mrbsizeRgrid}}.
}
\examples{
# Artificial sample data
set.seed(987)
sampleData <- matrix(stats::rnorm(100), nrow = 10)
sampleData[4:6, 6:8] <- sampleData[4:6, 6:8] + 5

# Generate samples from multivariate t-distribution
tSamp <- rmvtDCT(object = sampleData, lambda = 0.2, sigma = 6, nu0 = 15,
                   ns = 1000)  
 
# mrbsizeRgrid analysis
mrbOut <- mrbsizeRgrid(posteriorFile = tSamp$sample, mm = 10, nn = 10, 
                       lambdaSmoother = c(1, 1000), prob = 0.95)

# Posterior mean of the differences of smooths
plot(x = mrbOut$smMean, turnOut = TRUE)                    

# Credibility analysis using simultaneous credible intervals
plot(x = mrbOut$ciout, turnOut = TRUE)

}
