% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrct_functions.R
\name{mrct.plot}
\alias{mrct.plot}
\title{Plot function for result from \code{\link[=mrct]{mrct()}}}
\usage{
mrct.plot(mrct.object)
}
\arguments{
\item{mrct.object}{A result from a call to \code{\link[=mrct]{mrct()}}.}
}
\value{
Descriptive plots
\item{aMHD.plot}{Alpha-Mahalanobis distances, corresponding cutoff values and coloring according to estimated outliers (grey regular, black irregular).}
\item{aMHD.plot.w}{Same as \code{aMHD.plot}, with additional re-weighting step.}
}
\description{
A function for descriptive plots for an object resulting from a call to \code{\link[=mrct]{mrct()}}.
}
\examples{
# Similar to example in mrct() helpfile
# Fix seed for reproducibility
set.seed(123)

# Sample outlying indices
cont.ind <- sample(1:50, size=10)

# Generate 50 curves on the interval [0,1] at 50 timepoints with 20\% outliers
y <- mrct.rgauss(x.grid=seq(0,1,length.out=50), N=50, model=1,
                 outliers=cont.ind, method="linear")

# Visualize curves (regular curves grey, outliers black)
colormap <- rep("grey",50); colormap[cont.ind] <- "black"
matplot(x=seq(0,1,length.out=50), y=t(y), type="l", lty="solid",
        col=colormap, xlab="t",ylab="")

# Run MRCT
mrct.y <- mrct(data=y, h=0.75, alpha=0.1,
               initializations=10, criterion="sum")

# Visualize alpha-Mahalanobis distance
# Colorinfromation according to estimated outliers (grey regular, black irregular)
mrct.plot(mrct.y)
}
