% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseq.R
\name{parseq_fct}
\alias{parseq_fct}
\alias{parseq_factor}
\title{Generate a sequence of parameters}
\usage{
parseq_fct(mod, ..., .n = 5, .factor = 2, .geo = TRUE, .digits = NULL)

parseq_factor(mod, ..., .n = 5, .factor = 2, .geo = TRUE, .digits = NULL)
}
\arguments{
\item{mod}{a model object.}

\item{...}{unquoted parameter names.}

\item{.n}{number of parameters to simulate between the minimum
and maximum parameter values.}

\item{.factor}{a numeric vector used to divide and multiply the
parameter value thus generating the minimum and maximum parameter values,
respectively, for the sequence; if \code{.factor} is length 1 it will be
recycled to length 2; the first value is used to divide the nominal
value generating the minimum value; the second value is used to multiply
the nominal value generating the maximum value.}

\item{.geo}{if \code{TRUE} a geometric sequence is generated (evenly
spaced from min to max on log scale); otherwise, the sequence is
evenly spaced on Cartesian scale.}

\item{.digits}{if \code{numeric}, the number of significant digits in the
parameter sensitivity values are set using \code{\link[base:Round]{base::signif()}}.}
}
\description{
Generate a sequence of parameters
}
\details{
\itemize{
\item \code{.n}       is passed to \code{\link[=seq_fct]{seq_fct()}} as \code{n}
\item \code{.factor}  is passed to \code{\link[=seq_fct]{seq_fct()}} as \code{factor}
}
}
\examples{
mod <- mrgsolve::house()

mod \%>\%
  parseq_fct(CL,VC) \%>\% 
  sens_each()

}
\seealso{
\code{\link[=parseq_cv]{parseq_cv()}}, \code{\link[=parseq_range]{parseq_range()}}, \code{\link[=parseq_manual]{parseq_manual()}}
}
