% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_silhouette.R
\name{sort_silhouette}
\alias{sort_silhouette}
\title{Sort the silhouettes by group}
\usage{
sort_silhouette(sil, cluster)
}
\arguments{
\item{sil}{The \eqn{n}-vector of silhouette values.}

\item{cluster}{The \eqn{n}-vector of cluster indices.}
}
\value{
The \eqn{n}-vector of sorted silhouettes.
}
\description{
Sorts the silhouettes, first by group, then by value, preparatory to
plotting.
}
\examples{

# Uses sports data.
data(sportsranks)

# Obtain the K-means clustering for sports ranks.
kms <- kmeans(sportsranks, centers = 5, nstart = 10)

# Silhouettes
sil <- silhouette.km(sportsranks, kms$centers)
ssil <- sort_silhouette(sil, kms$cluster)
}
\seealso{
\code{\link{silhouette.km}}
}
