% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_error.R
\name{estimation_error}
\alias{estimation_error}
\title{Caluclate the estimation error of GMM parameters under the MTL setting (the worst performance among all tasks).}
\usage{
estimation_error(
  estimated_value,
  true_value,
  parameter = c("w", "mu", "beta", "Sigma")
)
}
\arguments{
\item{estimated_value}{estimate of GMM parameters. The form of input depends on the parameter \code{parameter}.}

\item{true_value}{true values of GMM parameters. The form of input depends on the parameter \code{parameter}.}

\item{parameter}{which parameter to calculate the estimation error for. Can be "w", "mu", "beta", or "Sigma".
\itemize{
\item w: the Gaussian mixture proportions. Both \code{estimated_value} and \code{true_value} require an input of a K-dimensional vector, where K is the number of tasks. Each element in the vector is an "w" (estimate or true value) for each task.
\item mu: Gaussian mean parameters. Both \code{estimated_value} and \code{true_value} require an input of a list of two p-by-K matrices, where p is the dimension of Gaussian distribution and K is the number of tasks. Each column of the matrix is a "mu1" or "mu2" (estimate or true value) for each task.
\item beta: discriminant coefficients. Both \code{estimated_value} and \code{true_value} require an input of a p-by-K matrix, where p is the dimension of Gaussian distribution and K is the number of tasks. Each column of the matrix is a "beta" (estimate or true value) for each task.
\item Sigma: Gaussian covariance matrices. Both \code{estimated_value} and \code{true_value} require an input of a list of K p-by-p matrices, where p is the dimension of Gaussian distribution and K is the number of tasks. Each matrix in the list is a "Sigma" (estimate or true value) for each task.
}}
}
\value{
the largest estimation error among all tasks.
}
\description{
Caluclate the estimation error of GMM parameters under the MTL setting (the worst performance among all tasks). Euclidean norms are used.
}
\note{
For examples, see examples in function \code{\link{mtlgmm}}.
}
\references{
Tian, Y., Weng, H., & Feng, Y. (2022). Unsupervised Multi-task and Transfer Learning on Gaussian Mixture Models. arXiv preprint arXiv:2209.15224.
}
\seealso{
\code{\link{mtlgmm}}, \code{\link{tlgmm}}, \code{\link{predict_gmm}}, \code{\link{data_generation}}, \code{\link{initialize}}, \code{\link{alignment}}, \code{\link{alignment_swap}}, \code{\link{misclustering_error}}.
}
