% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{contrast_predictions}
\alias{contrast_predictions}
\title{Estimate the Difference between Profiles}
\usage{
contrast_predictions(model, profile1, profile2, ...)
}
\arguments{
\item{model}{An object of class multimedia containing the estimated mediation
and outcome models whose mediation and outcome predictions we want to
compare.}

\item{profile1}{An object of class \code{treatment_profile} containing the first
treatment profile to consider in the difference.}

\item{profile2}{An object of class \code{treatment_profile} containing the second
treatment profile to consider in the difference.}

\item{...}{Additional arguments to pass to \code{predict()}.}
}
\value{
A list with two elements, \code{mediators} and \code{outcomes}, containing the
differences in the predicted M(T') - M(T) and Y(T', M(T')) - Y(T, M(T))
between the two profiles T and T'.
}
\description{
Given a fitted multimedia model, contrast the mediation and outcome
predictions associated wtih two treatment profiles.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
model <- multimedia(exper) |>
    estimate(exper)
t1 <- data.frame(treatment = factor("Treatment"))
t2 <- data.frame(treatment = factor("Control"))
profile1 <- setup_profile(model, t1, t1)
profile2 <- setup_profile(model, t2, t2)
contrast_predictions(model, profile1, profile2)
}
