% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{direct_effect}
\alias{direct_effect}
\title{Direct Effects from Estimated Model}
\usage{
direct_effect(model, exper = NULL, t1 = 1, t2 = 2)
}
\arguments{
\item{model}{An object of class multimedia containing the estimated mediation
and outcome models whose mediation and outcome predictions we want to
compare.}

\item{exper}{An object of class multimedia_data containing the mediation and
outcome data from which the direct effects are to be estimated.}

\item{t1}{The reference level of the treatment to be used when computing the
direct effect.}

\item{t2}{The alternative level of the treatment to be used when computing
the direct effect.}
}
\value{
A data.frame summarizing the direct effects associated with different
settings of j in the equation above.
}
\description{
Estimate direct effects associated with a multimedia model. These estimates
are formed using Equation (10) of our paper. Rather than providing this
average, this function returns the estimated difference for each $j$. To
average across all j, this result can be passed to the ' \code{effect_summary}
function.
}
\examples{
# example with null data
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
fit <- multimedia(exper) |>
    estimate(exper)

direct_effect(fit)
direct_effect(fit, t1 = 2, t2 = 1)
direct_effect(fit, t1 = 2, t2 = 2)

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
fit <- multimedia(exper) |>
    estimate(exper)
direct_effect(fit)
}
\seealso{
effect_summary
}
