% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{rf_model}
\alias{rf_model}
\title{Random Forest Model}
\usage{
rf_model(progress = TRUE, ...)
}
\arguments{
\item{progress}{A logical indicating whether to show a progress bar during
estimation.}

\item{...}{Keyword parameters passed to ranger() in the 'ranger' package.}
}
\value{
model An object of class \code{model} with estimator, predictor, and
sampler functions associated wtih a lienar model.
}
\description{
Apply a random forest model in parallel across a vector of responses $y$ in
either an outcome or mediation model. This is a natural choice when the
relationship between inputs and outputs is thought to be nonlinear.
Internally, each of the models across the response are estimated using
the 'ranger' package.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper, rf_model(num.trees = 10)) |>
    estimate(exper)

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper, rf_model(num.trees = 20, max.depth = 2)) |>
    estimate(exper)
}
\seealso{
model lm_model rf_model glmnet_model brms_model
}
