% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-examples.R
\name{example_smk_ume}
\alias{example_smk_ume}
\title{Example smoking UME NMA}
\description{
Calling \code{example("example_smk_ume")} will run an unrelated mean
effects (inconsistency) NMA model with the smoking cessation data, using the
code in the Examples section below. The resulting \code{stan_nma} object
\code{smk_fit_RE_UME} will then be available in the global environment.
}
\details{
Smoking UME NMA for use in examples.
}
\examples{
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net

\donttest{
# Fitting an unrelated mean effects (inconsistency) model
smk_fit_RE_UME <- nma(smk_net, 
                      consistency = "ume",
                      trt_effects = "random",
                      prior_intercept = normal(scale = 100),
                      prior_trt = normal(scale = 100),
                      prior_het = normal(scale = 5))

smk_fit_RE_UME
}

\dontshow{
if (requireNamespace("pkgdown", quietly = TRUE) && pkgdown::in_pkgdown()) {
  assign("smk_net", smk_net, .GlobalEnv)
  assign("smk_fit_RE_UME", smk_fit_RE_UME, .GlobalEnv)
}
}
}
\keyword{examples}
