% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_plots.R
\name{summary_plots}
\alias{summary_plots}
\title{Generate Summary Figures}
\usage{
summary_plots(
  effect_size_dataframe,
  Small_Sample_Correction,
  Significance_Level
)
}
\arguments{
\item{effect_size_dataframe}{Output from the \code{\link{classify_interactions}} function.}

\item{Small_Sample_Correction}{Whether the correction for small sample sizes should be enacted
(TRUE or FALSE; default is TRUE) \emph{Note that if the multiplicative null model (see \code{\link{effect_size_multiplicative}})
was implemented, this parameter is not used and can be ignored.
If the additive null model (see \code{\link{effect_size_additive}}) was implemented, then this
parameter should be assigned the same value as in that analysis}.}

\item{Significance_Level}{The value of alpha for which confidence intervals are calculated
(numeric, between 0 and 1; default is 0.05) \emph{Note that if the multiplicative null model (see \code{\link{effect_size_multiplicative}})
was implemented, this parameter is not used and can be ignored.
If the additive null model (see \code{\link{effect_size_additive}}) was implemented, then this
parameter should be assigned the same value as in that analysis}.}
}
\value{
The function returns a series of figures each of which is outlined above.
}
\description{
Using the output from \code{\link{classify_interactions}} function, summary figures can be created using this function.
}
\details{
The figures include:

 a) The proportions of the different interaction classifications from the dataset

 b) Median sample sizes plotted against effect size (different interaction classifications are highlighted).
    Where the additive null model was used in the analysis, lines for critical effect sizes are plotted
    (see \code{\link{critical_effect_size_additive}} function).

 c) Density of different median sample sizes.

 d) Inverse of effect size variance plotted against effect size (i.e., one iteration of a funnel plot).

 e) Effect size standard error (i.e., the square root of the effect size variance) plotted against effect size (i.e., one iteration of a funnel plot)).

 Note that c - e) are most useful for researchers conducting a meta-analysis.
}
\examples{

#loading up an example dataset from the multiplestressR package
df <- multiplestressR::survival

#calculating effect sizes
df <- effect_size_additive(Control_N         = df$Sample_Size_Control,
                           Control_SD        = df$Standard_Deviation_Control,
                           Control_Mean      = df$Mean_Control,
                           StressorA_N       = df$Sample_Size_Temperature,
                           StressorA_SD      = df$Standard_Deviation_Temperature,
                           StressorA_Mean    = df$Mean_Temperature,
                           StressorB_N       = df$Sample_Size_pH,
                           StressorB_SD      = df$Standard_Deviation_pH,
                           StressorB_Mean    = df$Mean_pH,
                           StressorsAB_N     = df$Sample_Size_Temperature_pH,
                           StressorsAB_SD    = df$Standard_Deviation_Temperature_pH,
                           StressorsAB_Mean  = df$Mean_Temperature_pH,
                           Significance_Level = 0.05);

#classifying interactions
df <- classify_interactions(effect_size_dataframe = df,
                   assign_reversals = TRUE,
                   remove_directionality = TRUE);

#generate summary plots
df_plots <- summary_plots(effect_size_dataframe = df,
                   Significance_Level = 0.05)

}
