% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{independence.test}
\alias{independence.test}
\title{test for independence}
\usage{
independence.test(
  x,
  vec = 1:ncol(x),
  alpha = 0.05,
  type = "distribution_free",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{either a data matrix or a list of doubly centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is a list, these are the indexes for which the multivariance is calculated. The default is all columns and all indexes, respectively.}

\item{alpha}{significance level}

\item{type}{one of \code{"pearson_approx","distribution_free","resample"}}

\item{verbose}{logical, if TRUE meaningful text output is generated.}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\value{
Returns \code{TRUE} if the hypothesis of independence is NOT rejected, otherwise \code{FALSE}.
}
\description{
Depreciated. Use \code{\link{multivariance.test}} instead. It provides all options and returns test result in a standard R format.
}
\details{
This computes a test of independence for the columns of a sample matrix (required for the resampling test) or for given doubly centered distance matrices (only possible for the distribution-free test).

The \code{"pearson_approx"} and \code{"resample"} are approximately sharp. The latter is based on a resampling approach and thus much slower. The \code{"distribution_free"} test might be very conservative.
The doubly centered distance matrices can be prepared by \code{\link{cdms}}. But note that for the test based on Pearson's approximation and for the resampling test, the data matrix has to be given.
}
\examples{
independence.test(coins(100)) #dependent sample which is 2-independent
independence.test(coins(100),type = "resample") #dependent sample which is 2-independent

independence.test(coins(100)[,2:3]) # independent sample
independence.test(coins(100)[,2:3],type = "resample") # independent sample

independence.test(coins(10),type = "resample") #dependent sample which is 2-independent
independence.test(coins(10)[,2:3],type = "resample") #dependent sample which is 2-independent

}
\references{
For the theoretic background see the references given on the main help page of this package: \link{multivariance-package}.
}
