% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{residualize}
\alias{residualize}
\title{Compute a regression model for each column in a matrix and return residual matrix}
\usage{
residualize(form, X, design, intercept = FALSE)
}
\arguments{
\item{form}{the formula defining the model to fit for residuals}

\item{X}{the response matrix}

\item{design}{the \code{data.frame} containing the design variables specified in \code{form} argument.}

\item{intercept}{add an intercept term (default is FALSE)}
}
\value{
a \code{matrix} of residuals
}
\description{
Compute a regression model for each column in a matrix and return residual matrix
}
\examples{

X <- matrix(rnorm(20*10), 20, 10)
des <- data.frame(a=rep(letters[1:4], 5), b=factor(rep(1:5, each=4)))
xresid <- residualize(~ a+b, X, design=des)

## design is saturated, residuals should be zero
xresid2 <- residualize(~ a*b, X, design=des)
sum(xresid2) == 0
}
