% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{ws3}
\alias{ws3}
\title{Within-subjects 2×2 design with polytomous response data}
\format{
A data frame with 60 observations on the following 4 variables:
\describe{
\item{PId}{a participant identifier with levels \code{"1"} ... \code{"15"}}
\item{X1}{a within-subjects factor with levels \code{"a"}, \code{"b"}}
\item{X2}{a within-subjects factor with levels \code{"c"}, \code{"d"}}
\item{Y}{a polytomous response with categories \code{"yes"}, \code{"no"}, \code{"maybe"}}
}
}
\description{
This generic synthetic long-format data set has a polytomous response \code{Y}
and two factors \code{X1} and \code{X2}. The response has categories
\code{\{yes, no, maybe\}}. Factor \code{X1} has levels \code{\{a, b\}}, and factor
\code{X2} has levels \code{\{c, d\}}. It also has a \code{PId} column for a
participant identifier. Participant identifiers are repeated across rows.
}
\examples{
\donttest{
library(multpois)
data(ws3, package="multpois")

ws3$PId = factor(ws3$PId)
ws3$Y = factor(ws3$Y, levels=c("yes","no","maybe"))
ws3$X1 = factor(ws3$X1)
ws3$X2 = factor(ws3$X2)
contrasts(ws3$X1) <- "contr.sum"
contrasts(ws3$X2) <- "contr.sum"

m = glmer.mp(Y ~ X1*X2 + (1|PId), data=ws3)
Anova.mp(m, type=3)
glmer.mp.con(m, pairwise ~ X1*X2, adjust="holm")
}

}
\seealso{
See \code{\link{glmer.mp}} and \code{\link{glmer.mp.con}} for complete examples.
}
\keyword{datasets}
