% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rawEMG.R
\name{plot_rawEMG}
\alias{plot_rawEMG}
\title{Plot raw EMG}
\usage{
plot_rawEMG(
  x,
  trial,
  plot_time = 3,
  start = 1,
  row_number = NA,
  col_number = 1,
  dark_mode = FALSE,
  line_size = 0.3,
  line_col = "black",
  show_plot = TRUE
)
}
\arguments{
\item{x}{Object of class \code{EMG} with elements \code{cycles} and \code{emg}}

\item{trial}{Character: the name of the considered trial, for archiving purposes}

\item{plot_time}{How many seconds of data should be plotted?}

\item{start}{At which data point should the plot start?}

\item{row_number}{How many rows should the final plot be divided into?}

\item{col_number}{How many columns should the final plot be divided into?}

\item{dark_mode}{To enable dark mode}

\item{line_size}{Line thickness}

\item{line_col}{Line colour}

\item{show_plot}{Logical, to decide whether plots should be plotted in the active graphic device}
}
\value{
Plots raw EMG trials of the specified length.
}
\description{
Plot raw EMG
}
\details{
If \code{show_plot} is TRUE (default) plots are also shown in the active graphic device.
Plots can then be saved with the preferred export method, such as \code{ggplot2::ggsave}.
}
\examples{
# Load some data
data(RAW_DATA)

# Save a plot with the first (and only) trial in RAW_DATA, first three seconds, in dark mode
plot_rawEMG(RAW_DATA[[1]],
  trial = names(RAW_DATA)[1],
  row_number = 4,
  col_number = 4,
  dark_mode = TRUE,
  line_col = "tomato3",
  show_plot = FALSE
)
}
