% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{playChord}
\alias{playChord}
\title{Play Chord}
\usage{
playChord(
  chord,
  type = c("harmonic", "ascending", "descending"),
  oscillator = "sine",
  duration = 1,
  sample.rate = 44100,
  attack.time = 50,
  inner.release.time = 50,
  A4 = 440,
  plot = FALSE,
  ...
)
}
\arguments{
\item{chord}{String, vector: Notes making up chord. e.g. c("A4", "C5", "E5").
e.g. output of \link{buildChord}}

\item{type}{String: "harmonic", "ascending", "descending". Default = "harmonic"}

\item{oscillator}{String: "sine", "square", "saw". Default = "sine"}

\item{duration}{Float: Note duration in beats. Default = 1}

\item{sample.rate}{Integer: Sample rate. Default = 44100}

\item{attack.time}{Integer: Attack time. Default = 50 (Helps prevent popping)}

\item{inner.release.time}{Integer: Release time, that ends on note OFF (instead of beginning at note OFF).
Default = 50 (Also helps prevent popping)}

\item{A4}{Float: Frequency for A4 in Hz. Default = 440}

\item{plot}{Logical: If TRUE, plot chord using \link{cplot.piano}}

\item{...}{Additional arguments to pass to \link{note2freq}}
}
\value{
The constructed waveform (invisibly)
}
\description{
Play Chord
}
\examples{
\dontrun{
playChord(buildChord("E4", "minor"))
}
}
\author{
E.D. Gennatas
}
