% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg.plot.R
\name{avg.plot}
\alias{avg.plot}
\title{Averaged simulated values plot function}
\usage{
avg.plot(
  data.mat,
  start,
  end,
  x.lab = "Iteration number",
  y.lab = "Average of simulated values",
  title = NULL,
  details = FALSE
)
}
\arguments{
\item{data.mat}{data matrix including the simulated values for plot.}

\item{start}{the number of cycle to start.}

\item{end}{the number of cycle to end.}

\item{x.lab}{label of the x axis in the generated plot, default is set to "Iteration number".}

\item{y.lab}{label of the y axis in the generated plot, default is set to "Average of simulated values".}

\item{title}{title of each generated plot.}

\item{details}{logical variable to specify whether the average simulated values are returned, default is set to FALSE.}
}
\value{
The plot of averaged values across iterations. If \code{details} = TRUE,
a matrix containing the averaged values of all the variables across iterations will be returned.
}
\description{
Calculates the average simulated values of all parameters and generates plots.
}
\details{
This function calculates the average simulated values across simulations.
\code{iter} can be any number of iterations you want to draw, the corresponding number of rows
of the data should be \code{iter} + 1.
}
\examples{

### generate some normal data
dat <- MASS::mvrnorm(n = 1000, mu = c(1, 2, 3, 4), Sigma = diag(4))

### set column names
colnames(dat) <- paste0("Var ", 1:ncol(dat))

### average values plot: take sample from 500 to 1000 rows
avg.plot(data.mat = dat[500:1000, ], start = 500, end = 1000, title = "Random Variables")

}
