% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RF.R
\name{RF}
\alias{RF}
\title{Function for fitting random forests with multi-view stacking}
\usage{
RF(
  x,
  y,
  view,
  view.names = NULL,
  skip.meta = FALSE,
  skip.cv = FALSE,
  na.action = "fail",
  na.arguments = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{x}{input matrix of dimension nobs x nvars}

\item{y}{outcome vector of length nobs}

\item{view}{a vector of length nvars, where each entry is an integer describing to which view each feature corresponds.}

\item{view.names}{(optional) a character vector of length nviews specifying a name for each view.}

\item{skip.meta}{whether to skip training the metalearner.}

\item{skip.cv}{whether to skip generating the cross-validated predictions.}

\item{na.action}{character specifying what to do with missing values (NA). Options are "pass", "fail", "mean", "mice", and "missForest". Options "mice" and "missForest" requires the respective R package to be installed. Defaults to "pass".}

\item{na.arguments}{(optional) a named list of arguments to pass to the imputation function (e.g. to \code{mice} or \code{missForest}).}

\item{progress}{whether to show a progress bar (only supported when parallel = FALSE).}

\item{...}{Additional arguments to be passed to function \code{\link[randomForest]{randomForest}}.}
}
\value{
An object with S3 class "RF".
}
\description{
A wrapper function around randomForest from package of the same name that allows to use it in function MVS.
}
\examples{
\donttest{
set.seed(012)
n <- 1000
cors <- seq(0.1,0.7,0.1)
X <- matrix(NA, nrow=n, ncol=length(cors)+1)
X[,1] <- rnorm(n)

for(i in 1:length(cors)){
  X[,i+1] <- X[,1]*cors[i] + rnorm(n, 0, sqrt(1-cors[i]^2))
}

beta <- c(1,0,0,0,0,0,0,0)
eta <- X \%*\% beta
p <- exp(eta)/(1+exp(eta))
y <- rbinom(n, 1, p) ## create binary response
view_index <- rep(1:(ncol(X)/2), each=2)

# Stacked random forest
fit <- RF(X, y, view_index, skip.meta = FALSE, skip.cv = FALSE)

# Stacked random forest
y <- eta + rnorm(100) ## create continuous response
fit <- RF(X, y, view_index,skip.meta = FALSE, skip.cv = FALSE)
}
}
\author{
Marjolein Fokkema <m.fokkema@fsw.leidenuniv.nl>
}
\keyword{TBA}
