% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classicTB.R
\name{tb_palette}
\alias{tb_palette}
\title{Generate n colors from a mycolorsTB palette}
\usage{
tb_palette(n, palette_name = "classicTB")
}
\arguments{
\item{n}{The number of colors to generate.}

\item{palette_name}{The name of the palette to use ("mycolors", "classicTB", or "pathogenomics").}
}
\value{
A character vector of n hex color codes.
}
\description{
Uses color interpolation to create a custom number of colors from a given palette.
}
\examples{
# Generate 20 colors from the 'classicTB' palette
my_custom_colors <- tb_palette(20, "classicTB")
plot(1:20, 1:20, col = my_custom_colors, pch = 19, cex = 3)
}
