% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{fold.cv.ncpen}
\alias{fold.cv.ncpen}
\title{fold.cv.ncpen: extracts fold ids for \code{cv.ncpen}.}
\usage{
fold.cv.ncpen(c.vec, n.fold = 10, family = c("gaussian", "binomial",
  "multinomial", "cox", "poisson"))
}
\arguments{
\item{c.vec}{(numeric vector) vector for construction of CV ids:
censoring indicator for \code{cox} and response vector for the others.}

\item{n.fold}{(numeric) number of folds for CV.}

\item{family}{(character) regression model. Supported models are
\code{gaussian},
\code{binomial},
\code{poisson},
\code{multinomial},
and \code{cox}.
Default is \code{gaussian}.}
}
\value{
fold ids of the samples.
 \item{idx}{fold ids.}
 \item{n.fold}{the number of folds.}
 \item{family}{the model.}
}
\description{
The function returns fold configuration of the samples for CV.
}
\examples{
### linear regression with scad penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,cf.min=0.5,cf.max=1,corr=0.5)
x.mat = sam$x.mat; y.vec = sam$y.vec
fold.id = fold.cv.ncpen(c.vec=y.vec,n.fold=10)
### logistic regression with classo penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,cf.min=0.5,cf.max=1,corr=0.5,family="binomial")
x.mat = sam$x.mat; y.vec = sam$y.vec
fold.id = fold.cv.ncpen(c.vec=y.vec,n.fold=10,family="binomial")
### poison regression with mlog penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,cf.min=0.5,cf.max=1,corr=0.5,family="poisson")
x.mat = sam$x.mat; y.vec = sam$y.vec
fold.id = fold.cv.ncpen(c.vec=y.vec,n.fold=10,family="poisson")
### multinomial regression with sridge penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,k=3,cf.min=0.5,cf.max=1,corr=0.5,family="multinomial")
x.mat = sam$x.mat; y.vec = sam$y.vec
fold.id = fold.cv.ncpen(c.vec=y.vec,n.fold=10,family="multinomial")
### cox regression with mcp penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,r=0.2,cf.min=0.5,cf.max=1,corr=0.5,family="cox")
x.mat = sam$x.mat; y.vec = sam$y.vec
fold.id = fold.cv.ncpen(c.vec=x.mat[,21],n.fold=10,family="cox")
}
\references{
Lee, S., Kwon, S. and Kim, Y. (2016). A modified local quadratic approximation algorithm for penalized optimization problems.
\emph{Computational Statistics and Data Analysis}, 94, 275-286.
}
\seealso{
\code{\link{cv.ncpen}}, \code{\link{plot.cv.ncpen}} , \code{\link{gic.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
