% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbresidual.R
\name{nbresidual}
\alias{nbresidual}
\title{Extract Pearson residuals from the results of NEBULA}
\usage{
nbresidual(nebula, count, id, pred = NULL, offset = NULL, conditional = FALSE)
}
\arguments{
\item{nebula}{An object of the result obtained from running the function nebula.}

\item{count}{A raw count matrix of the single-cell data. The rows are the genes, and the columns are the cells. The matrix can be a matrix object or a sparse dgCMatrix object.}

\item{id}{A vector of subject IDs. The length should be the same as the number of columns of the count matrix.}

\item{pred}{A design matrix of the predictors. The rows are the cells and the columns are the predictors. If not specified, an intercept column will be generated by default.}

\item{offset}{A vector of the scaling factor. The values must be strictly positive. If not specified, a vector of all ones will be generated by default.}

\item{conditional}{A logical value. By default (FALSE), the function returns marginal Pearson residuals. If TRUE, the function will return conditional Pearson residuals.}
}
\value{
residuals: A matrix of Pearson residuals. The number of columns is the number of cells in the count matrix. The rows correspond to gene IDs reported in the result from nebula.

gene: Gene names corresponding to the row names of the count matrix.
}
\description{
Extract Pearson residuals from the results of NEBULA
}
\examples{
library(nebula)
data(sample_data)
pred = model.matrix(~X1+X2+cc,data=sample_data$pred)
re = nebula(count=sample_data$count,id=sample_data$sid,pred=pred)
resid = nbresidual(re,count=sample_data$count,id=sample_data$sid,pred=pred)

}
