% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visNetwork.R
\name{createVisNetwork}
\alias{createVisNetwork}
\title{createVisNetwork}
\usage{
createVisNetwork(
  nodes,
  edges,
  background = "lightblue",
  border = "darkblue",
  highlight = "yellow"
)
}
\arguments{
\item{nodes}{Nodes.}

\item{edges}{Edges.}

\item{background}{Background color.}

\item{border}{Border color.}

\item{highlight}{Highlight color.}
}
\value{
Network map visualization
}
\description{
Generates network map using the nodes and edges objects generated by
getNodes and getEdges functions respectively.
}
\examples{
nodes <- getNodes(head(mtcars), c("cyl", "gear", "vs"), group = TRUE)
res <- fixNodeBias(head(mtcars))
edges <- getEdges(getAssociation(res), getNodes(res, group = TRUE))
createVisNetwork(nodes, edges)
}
\author{
Jayachandra N
}
