% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparable.pairs.R
\name{incomparable_pairs}
\alias{incomparable_pairs}
\title{Incomparable pairs in a partial order}
\usage{
incomparable_pairs(P)
}
\arguments{
\item{P}{A partial order as matrix object, e.g. calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}
}
\value{
Fraction of incomparable pairs in \code{P}.
}
\description{
Calculates the fraction of incomparable pairs in a partial order.
}
\examples{
library(igraph)
g <- sample_gnp(100, 0.1)
P <- neighborhood_inclusion(g)
comparable_pairs(P)
# All pairs of vertices are comparable in a threshold graph
tg <- threshold_graph(100, 0.3)
P <- neighborhood_inclusion(g)
comparable_pairs(P)
}
\seealso{
\link{comparable_pairs}
}
\author{
David Schoch
}
