% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{inverse_trans}
\alias{inverse_trans}
\alias{inverse_trans,NeuroSpace-method}
\title{Extract inverse image coordinate transformation}
\usage{
inverse_trans(x)

\S4method{inverse_trans}{NeuroSpace}(x)
}
\arguments{
\item{x}{an object}
}
\value{
A numeric 4x4 \code{matrix} that maps from real-world coordinates back to grid coordinates.
}
\description{
Extract inverse image coordinate transformation
}
\examples{
bspace <- NeuroSpace(c(10,10,10), c(2,2,2))
itrans <- inverse_trans(bspace)
identical(trans(bspace) \%*\% inverse_trans(bspace), diag(4))
}
