% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/graph.R
\docType{methods}
\name{as_graph}
\alias{as_graph}
\alias{as_graph-method}
\alias{as_graph,LR-method}
\alias{as_graph,ALR-method}
\alias{as_graph,ILR-method}
\title{Graph of Log-ratios}
\usage{
as_graph(object, ...)

\S4method{as_graph}{LR}(object)

\S4method{as_graph}{ALR}(object)

\S4method{as_graph}{ILR}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{LogRatio}} object.}

\item{...}{Currently not used.}
}
\value{
An \pkg{igraph} graph object.
}
\description{
Produces a graph of log-ratios.
}
\examples{
if (requireNamespace("igraph", quietly = TRUE)) {

library(igraph)

## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Pairwise log-ratio
lr <- transform_lr(coda)
lr_graph <- as_graph(lr)
plot(lr_graph)

## Additive log-ratio
alr <- transform_alr(coda)
alr_graph <- as_graph(alr)
plot(alr_graph)

## Isometric log-ratio
ilr <- transform_ilr(coda)
ilr_graph <- as_graph(ilr)
plot(ilr_graph)

plr <- transform_plr(coda)
plr_graph <- as_graph(plr)
plot(plr_graph)

}
}
\seealso{
Other plot methods: 
\code{\link{barplot}()},
\code{\link{boxplot}()},
\code{\link{hist}()},
\code{\link{pairs}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
